module net.BurtonRadons.dig.common.imageLoaderTGA;

/+
#ifdef DOXYGOHOME
+/

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.common.imageLoader;
//import std.stream;


struct digCommonBaseLoader_tga
{
    std.stream.Stream stream;
    ImageFile image;
    char [] filename;

    int idLength;
    int paletteType;
    int imageType;
    int firstColor;
    int paletteColors;
    int paletteEntrySize;
    int left;
    int top;
    int width;
    int height;
    int bpp;
    int descriptorBits;
    int compressed;
    bit alpha;
    char [] type;

    void read8 (ubyte* data, int length, int compressed)
    {
        ubyte value, count;
        int c = 0;
    
        if (!compressed)
        {
            stream.readExact (data, length);
            return;
        }
    
        do 
        {
            stream.readExact (&count, 1);
            if (count & 0x80)
            {
                count = (count & 0x7F) + 1;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                stream.readExact (&value, 1);
                while (count --)
                    *data ++ = value;
            }
            else
            {
                count ++;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                stream.readExact (data, count);
            }
        }
        while (c < length);
    }

    void store32 (ubyte *data, ubyte r, ubyte g, ubyte b, ubyte a)
    {
        data [0] = r;
        data [1] = g;
        data [2] = b;
        data [3] = a;
    }

    /* length here is in quadruplets */
    void read32 (ubyte *data, int length, int compressed)
    {
        ubyte[4] value;
        ubyte count;
        int c = 0;
    
        if (!compressed)
        {
            for (c = 0; c < length; c ++, data += 4)
            {
                stream.readExact (value, 4);
                store32 (data, value [2], value [1], value [0], value [3]);
            }
        }
        else do
        {
            stream.readExact (&count, 1);
            if (count & 0x80)
            {
                count = (count & 0x7F) + 1;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                stream.readExact (value, 4);
                while (count --)
                {
                    store32 (data, value [2], value [1], value [0], value [3]);
                    data += 4;
                }
            }
            else
            {
                count ++;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                while (count --)
                {
                    stream.readExact (value, 4);
                    store32 (data, value [2], value [1], value [0], value [3]);
                    data += 4;
                }
            }
        }
        while (c < length);
    }

    /* length here is in triplets */
    void rle_read24 (ubyte* data, int length)
    {
        ubyte[3] value;
        ubyte count;
        int c = 0;
    
        do
        {
            stream.readExact (&count, 1);
            if (count & 0x80)
            {
                count = (count & 0x7F) + 1;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                stream.readExact (value, 3);
                while (count --)
                {
                    *data ++ = value [2];
                    *data ++ = value [1];
                    *data ++ = value [0];
                }
            }
            else
            {
                count ++;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                while (count --)
                {
                    stream.readExact (value, 3);
                    *data ++ = value [2];
                    *data ++ = value [1];
                    *data ++ = value [0];
                }
            }
        }
        while (c < length);
    }

    void rle_read16 (ubyte* data, int length)
    {
        ubyte[2] value;
        ubyte count;
        ushort color;
        int c = 0;
    
        do
        {
            stream.readExact (&count, 1);
            if (count & 0x80)
            {
                count = (count & 0x7F) + 1;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                stream.readExact (value, 2);
                color = value [0] | (value [1] << 8);
                while (count --)
                {
                    data [0] = ((color >> 10) & 31) * 255 / 31;
                    data [1] = ((color >> 5) & 31) * 255 / 31;
                    data [2] = (color & 31) * 255 / 31;
                }
            }
            else
            {
                count ++;
                c += count;
                if (c > length)
                    throw new Error ("Data overrun");
                while (count --)
                {
                    stream.readExact (value, 2);
                    color = value [0] | (value [1] << 8);
                    data [0] = ((color >> 10) & 31) * 255 / 31;
                    data [1] = ((color >> 5) & 31) * 255 / 31;
                    data [2] = (color & 31) * 255 / 31;
                }
            }
        }
        while (c < length);
    }

    float identify ()
    {
        ubyte [18] data;

        if (stream.read (data) != data.length)
            return 0;
        idLength = data [0];
        paletteType = data [1];
        imageType = data [2];
        firstColor = data [3] | (data [4] << 8);
        paletteColors = data [5] | (data [6] << 8);
        paletteEntrySize = data [7];
        left = data [8] | (data [9] << 8);
        top = data [10] | (data [11] << 8);
        width = data [12] | (data [13] << 8);
        height = data [14] | (data [15] << 8);
        bpp = data [16];
        descriptorBits = data [17];
        compressed = (imageType & 8) ? 1 : 0;
        imageType &= 7;

        if (imageType == 2)
        {
            if (paletteType != 0 || (bpp != 15 && bpp != 16 && bpp != 24 && bpp != 32))
                return 0;
            type = "rgb";
            if (bpp == 32)
                alpha = true;
        }
        else if (imageType == 3)
        {
            if (paletteType || bpp != 8)
                return 0;
            type = "luminance";
        }
        else
            return 0;

        return 1;
    }

    void load ()
    {
        ubyte[] row;
        int y, yc, x;

        identify ();
        stream.seekCur (idLength);
        assert (!paletteColors);
        image.dimensions (width, height, 8, type, alpha);
        row = new ubyte [image.bytesPerRow ()];

        for (y = height; y > 0; y --)
        {
            yc = (descriptorBits & 0x20) ? height - y : y - 1;

            if (imageType == 1 || imageType == 3)
                read8 (row, width, compressed);
            else if (imageType == 2)
            {
                if (bpp == 32)
                    read32 (row, width, compressed);
                else if (bpp == 24)
                {
                    if (compressed)
                        rle_read24 (row, width);
                    else
                    {
                        stream.read (row);
                        for (int c = 0; c < width * 3; c += 3)
                        {
                            ubyte a = row [c];
                            row [c] = row [c + 2];
                            row [c + 2] = a;
                        }
                    }
                }
                else if (bpp == 16 || bpp == 15)
                {
                    if (compressed)
                        rle_read16 (row, width);
                    else
                    {
                        stream.read (row [0 .. width * 2]);
                        for (int x = width - 1; x >= 0; x --)
                        {
                            ushort color = row [x * 2 + 0] | (row [x * 2 + 1] << 8);

                            row [x * 3 + 0] = ((color >> 10) & 31) * 255 / 31;
                            row [x * 3 + 1] = ((color >> 5) & 31) * 255 / 31;
                            row [x * 3 + 2] = (color & 31) * 255 / 31;
                        }
                    }
                }
                else
                    assert (0);
            }
            else
                assert (0);

            image.row (yc, row);
        }
    }
}

class digCommonImageLoader_tga : ImageLoader
{
    char [] name () { return "Targa"; }
    char [] exts () { return "*.tga"; }

    float match ()
    {
        digCommonBaseLoader_tga base;

        base.stream = stream;
        return base.identify ();
    }

    void load ()
    {
        digCommonBaseLoader_tga base;

        base.stream = stream;
        base.image = image;
        base.filename = filename;
        base.load ();
    }
}

/+
#endif
+/

/+

static int
_detect (br_resource *resource, br_stream *stream)
{
    struct _info info;
    
    (void) resource;
    return _identify (stream, &info);
}

static int
_load (br_resource *resource, br_stream *stream)
{
    int reply;
    
    reply = _load_ex (resource, stream);
    br_stream_close (stream);
    return reply;
}

void
br_texture_tga_init (void)
{
    br_resource_loader_register ("tga", "Targa bitmap", br_texture_type, _detect, _load, NULL, NULL);
}
+/